/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.LogoHardwareFactory;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfAnchor;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfParameter;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfProgramm;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class PartsOfLgo {
    protected int[] fLgoInt = null;
    protected String[] fLgoFile = null;
    protected PartsOfProgramm fPoP = null;
    protected PartsOfParameter fPoPara = null;
    protected Hardware fHardware = null;
    private Vector fComments = null;
    public String[] CONNECTOR_NAMES = new String[]{"I1", "I2", "I3", "I4", "I5", "I6", "I7", "I8", "I9", "I10", "I11", "I12", "Ia1", "Ia2", "Ia3", "Ia4", "Q1", "Q2", "Q3", "Q4", "Q5", "Q6", "Q7", "Q8", "Qa1", "Qa2", "Qa3", "Qa4", "M1", "M2", "M3", "M4"};

    public PartsOfLgo() {
    }

    public PartsOfLgo(String[] lgoData) {
        this.fLgoFile = lgoData;
        this.initLgoInt();
        this.initPartsOfLgo();
    }

    public PartsOfLgo(String fileName) throws ProgramException {
        this.openFile(fileName);
        this.initLgoInt();
        this.initPartsOfLgo();
    }

    public PartsOfAnchor getAnchorObject() {
        PartsOfAnchor anchor = new PartsOfAnchor(this.fLgoFile);
        return anchor;
    }

    protected int getAnchorStartIndex() {
        int posKopf = 4;
        if (this.getHardwareID() == 0) {
            posKopf = 2;
        }
        if (this.getHardwareID() == 0 && this.fLgoInt[1] == 1) {
            posKopf = 4;
        }
        return posKopf;
    }

    public int[] getConnections(int index) {
        if (this.fPoP == null) {
            this.fPoP = new PartsOfProgramm(this.fLgoFile);
        }
        int[] zeile = this.fPoP.getConnectionToBlock(index);
        return zeile;
    }

    public int getCountOfBlocks() {
        if (this.fPoP == null) {
            this.fPoP = new PartsOfProgramm(this.fLgoFile);
        }
        return this.fPoP.getNumberOfProgLines();
    }

    public int getFirstParaLine() {
        if (this.getHardwareID() > 3) {
            return 121;
        }
        return 95;
    }

    public int getHardwareID() {
        if (this.fLgoInt[1] == 1) {
            return 0;
        }
        if (this.fLgoInt[1] > 6) {
            return 0;
        }
        return this.fLgoInt[1];
    }

    private int getHardwareIDComfort() {
        int softHardwareID = this.getHardwareID();
        if (softHardwareID == 2) {
            return 1;
        }
        if (softHardwareID == 6) {
            return 7;
        }
        return softHardwareID;
    }

    public int getHardwareInfo(Hardware hardware, String resource) {
        String[] resNames = HardwareFactory.getInstance().getResourceNames();
        for (int i = 0; i < resNames.length; ++i) {
            if (!resNames[i].equals(resource)) continue;
            return hardware.getMaxResource(i);
        }
        return 0;
    }

    public Hashtable getIOPortComments() {
        this.readIOPorts();
        Hashtable retHash = new Hashtable(40);
        int nextGroupNameStart = 0;
        int nextGroupStart = 0;
        int[] nextGroup = new int[]{16, 12, 4};
        int[] maxPorts = new int[]{this.getMaxInput() + this.getMaxAsiInput(), this.getMaxOutput() + this.getMaxAsiOutput(), this.getMaxMarker()};
        for (int i = 0; i < maxPorts.length; ++i) {
            for (int d = 0; d < maxPorts[i]; ++d) {
                String key = this.CONNECTOR_NAMES[d + nextGroupStart];
                try {
                    retHash.put(key, this.fComments.elementAt(d + nextGroupNameStart));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            nextGroupStart += nextGroup[i];
            if (this.getVersion() > 3000) {
                nextGroupNameStart = nextGroupStart;
                continue;
            }
            nextGroupNameStart += maxPorts[i];
        }
        return retHash;
    }

    public int getMaxAsiInput() {
        String value = "DigitalInputASi";
        return this.getHardwareInfo(this.fHardware, value);
    }

    public int getMaxAsiOutput() {
        String value = "DigitalOutputASi";
        return this.getHardwareInfo(this.fHardware, value);
    }

    public int getMaxInput() {
        String value = "DigitalInput";
        return this.getHardwareInfo(this.fHardware, value);
    }

    public int getMaxMarker() {
        String value = "Marker";
        return this.getHardwareInfo(this.fHardware, value);
    }

    public int getMaxOutput() {
        String value = "DigitalOutput";
        if (this.getHardwareID() == 0 && this.fLgoInt[1] == 1) {
            return this.fLgoInt[2];
        }
        return this.getHardwareInfo(this.fHardware, value);
    }

    public PartsOfParameter getParameterObject() {
        PartsOfParameter para = new PartsOfParameter(this.fLgoFile);
        return para;
    }

    public int[][] getParameters(int index) {
        if (this.fPoP == null) {
            this.fPoP = new PartsOfProgramm(this.fLgoFile);
        }
        PartsOfParameter para = new PartsOfParameter(this.fLgoFile);
        int[] progZeile = this.fPoP.getProgPart2()[index];
        int anzahl = 0;
        int startPara = this.getFirstParaLine();
        for (int i = 0; i < progZeile.length; ++i) {
            if (progZeile[i] < startPara) continue;
            ++anzahl;
        }
        int[][] parameter = new int[anzahl][progZeile.length];
        anzahl = 0;
        for (int i = 0; i < progZeile.length; ++i) {
            if (progZeile[i] < startPara) continue;
            int postition = progZeile[i] - startPara;
            parameter[anzahl] = para.getPara2()[postition];
            ++anzahl;
        }
        return parameter;
    }

    protected int getParaStartIndex() {
        if (this.fPoP == null) {
            this.fPoP = new PartsOfProgramm(this.fLgoFile);
        }
        int startIndex = this.getProgStartIndex() + this.fPoP.getLengthOfProg() + 1;
        return startIndex;
    }

    public int[] getProgOpCodes() {
        if (this.fPoP == null) {
            this.fPoP = new PartsOfProgramm(this.fLgoFile);
        }
        return this.fPoP.getOPCodes();
    }

    public PartsOfProgramm getProgrammObject() {
        if (this.fPoP == null) {
            this.fPoP = new PartsOfProgramm(this.fLgoFile);
        }
        return this.fPoP;
    }

    protected int getProgStartIndex() {
        int pos = this.getAnchorStartIndex() + this.getMaxOutput() + this.getMaxAsiOutput() + this.getMaxMarker() + 1;
        return pos;
    }

    public int getVersion() {
        if (this.fLgoInt[0] < 1000) {
            return 0;
        }
        return this.fLgoInt[0];
    }

    private void initFLgoFile(int anzahl) {
        this.fLgoFile = new String[anzahl];
    }

    private void initLgoInt() {
        if (this.fLgoInt == null) {
            int i;
            int[] zwspeicher = new int[this.fLgoFile.length];
            int zwbelegteElemente = 0;
            try {
                for (i = 0; i < zwspeicher.length; ++i) {
                    zwspeicher[i] = Integer.parseInt(this.fLgoFile[i]);
                    ++zwbelegteElemente;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.fLgoInt = new int[zwbelegteElemente];
            for (i = 0; i < zwbelegteElemente; ++i) {
                this.fLgoInt[i] = zwspeicher[i];
            }
        }
    }

    private void initPartsOfLgo() {
        this.fHardware = ((LogoHardwareFactory)HardwareFactory.getInstance()).getHardware(this.getHardwareIDComfort());
    }

    public boolean isIOPortCommentsAvailable() {
        this.readIOPorts();
        return this.fComments != null;
    }

    public void openFile(String fileName) throws ProgramException {
        int anzahlElemente = 0;
        int zeilenZaehler = 0;
        String inhaltZeile = "";
        BufferedReader lgoDatei = null;
        try {
            lgoDatei = new BufferedReader(new FileReader(fileName));
            while ((inhaltZeile = lgoDatei.readLine()) != null) {
                ++anzahlElemente;
            }
            this.initFLgoFile(anzahlElemente);
            lgoDatei.close();
            lgoDatei = new BufferedReader(new FileReader(fileName));
            while ((inhaltZeile = lgoDatei.readLine()) != null) {
                this.fLgoFile[zeilenZaehler] = inhaltZeile = inhaltZeile.trim();
                ++zeilenZaehler;
            }
            lgoDatei.close();
        }
        catch (IOException e) {
            ProgramException pE = new ProgramException();
            String s = Language.getString("error.import.wrongFileName", "FileName not Found");
            pE.set(s, "u");
            pE.set("Methode openFile()", "e");
            pE.set("Zeile " + zeilenZaehler, "e");
            throw pE;
        }
    }

    private void readIOPorts() {
        if (this.fComments == null) {
            int zwbelegteElemente;
            if (this.fPoPara == null) {
                this.fPoPara = new PartsOfParameter(this.fLgoFile);
            }
            for (int i = zwbelegteElemente = this.getParaStartIndex() + this.fPoPara.getLengthOfPara(); i < this.fLgoFile.length; ++i) {
                if (this.fComments == null) {
                    this.fComments = new Vector();
                }
                this.fComments.add(this.fLgoFile[i]);
            }
            if (this.fComments != null) {
                boolean sinnvoll = false;
                for (int i = 0; i < this.fComments.size(); ++i) {
                    if (this.fComments.elementAt(i).equals("")) continue;
                    sinnvoll = true;
                    break;
                }
                if (!sinnvoll) {
                    this.fComments = null;
                }
            }
        }
    }

    public String toString() {
        String ret = "";
        ret = this.getAnchorObject().toString() + "\n" + this.getProgrammObject().toString() + "\n" + this.getParameterObject().toString();
        return ret;
    }

    public int whichInnovation() {
        if (this.getHardwareID() > 3) {
            return 1;
        }
        return 0;
    }
}

